//hi, welcome to hell
#include "arm7tdmi.h"
/*********************************************************************************************/
#define USERBANK			0
#define FIQBANK			1
#define SUPERVISORBANK	2
#define ABORTBANK			3
#define IRQBANK			4
#define UNDEFINEDBANK	5
#define PC					regs[15]
#define CPSR				regs[16]
#define SPSR				regs[17]
#define OPCODE				opcode
#define REGS(regnum)		regs[regnum]
#define CHECKNZ_32(v)\
zeroflag = 0;\
negativeflag = 0;\
if(v == 0)\
	zeroflag = 1;\
else\
	negativeflag = (u8)(v >> 31);
#define CHECKNZ_16(v)\
zeroflag = 0;\
negativeflag = 0;\
if(v == 0)\
	zeroflag = 1;\
else\
	negativeflag = (u8)((u16)v >> 15);
#define CHECKNZ_8(v)\
zeroflag = 0;\
negativeflag = 0;\
if(v == 0)\
	zeroflag = 1;\
else\
	negativeflag = (u8)v >> 7;
/*********************************************************************************************/
typedef void (*execfunc)();
/*********************************************************************************************/
u32 cyclesexec;
static u32 execerror;
static u8 mode = SUPERVISOR;
static u32 (*executefunc)();
static void (*fillpipe)();
static void (*incpipe)();
static void (*initmode)();
static u32 addr;
static u32 opcode;
static u32 result;
static u8 rn,rd,rm,rs; //some temp vars
static u32 cycles;
static execfunc ops[256*16];
static u32 thumb_to_arm[0x10000];
static u8 negativeflag,zeroflag,carryflag,overflowflag;
//shit in the context
static u32 regs[18]; //r0 - r15 + cpsr + spsr
static u32 regsaves[6][18]; //for different modes
static u32 pipe[3]; //instruction pipeline
static u8 state; //arm or thumb
static u8 (*read8)(u32 addr);
static u16 (*read16)(u32 addr);
static u32 (*read32)(u32 addr);
static void (*write8)(u32 addr,u8 value);
static void (*write16)(u32 addr,u16 value);
static void (*write32)(u32 addr,u32 value);
/*********************************************************************************************/
static INLINE void lazyflags(u32 cpsr)
{
negativeflag = 0;
zeroflag = 0;
carryflag = 0;
overflowflag = 0;
if(cpsr & NEGATIVE)
	negativeflag = 1;
if(cpsr & ZERO)
	zeroflag = 1;
if(cpsr & CARRY)
	carryflag = 1;
if(cpsr & OVERFLOW)
	overflowflag = 1;
}
/*********************************************************************************************/
static INLINE u32 notlazyflags(u32 cpsr)
{
cpsr &= 0x0fffffff;
if(negativeflag)
	cpsr |= NEGATIVE;
if(zeroflag)
	cpsr |= ZERO;
if(carryflag)
	cpsr |= CARRY;
if(overflowflag)
	cpsr |= OVERFLOW;
return(cpsr);
}
/*********************************************************************************************/
static INLINE void fillpipe_arm()
{
pipe[0] = read32(PC);
PC += 4;
pipe[1] = read32(PC);
PC += 4;
pipe[2] = read32(PC);
}
/*********************************************************************************************/
static INLINE void incpipe_arm()
{
pipe[0] = pipe[1];
pipe[1] = pipe[2];
PC += 4;
pipe[2] = read32(PC);
}
/*********************************************************************************************/
static INLINE void fillpipe_thumb()
{
pipe[0] = (u32)read16(PC);
PC += 2;
pipe[1] = (u32)read16(PC);
PC += 2;
pipe[2] = (u32)read16(PC);
}
/*********************************************************************************************/
static INLINE void incpipe_thumb()
{
pipe[0] = pipe[1];
pipe[1] = pipe[2];
PC += 2;
pipe[2] = (u32)read16(PC);
}
/*********************************************************************************************/
static INLINE void armmode()
{
state = ARM_MODE;
CPSR &= ~STATE_BIT; //clear state bit (set arm mode)
fillpipe = fillpipe_arm;
incpipe = incpipe_arm;
}
/*********************************************************************************************/
static INLINE void thumbmode()
{
state = THUMB_MODE;
CPSR |= STATE_BIT; //set state bit (set thumb mode)
fillpipe = fillpipe_thumb;
incpipe = incpipe_thumb;
}
/*********************************************************************************************/
static INLINE void do_cmp(u32 op1,u32 op2)
{
__asm
	{
	mov	eax,op1
	cmp	eax,op2
	sets	negativeflag
	setz	zeroflag
	setnc	carryflag
	seto	overflowflag
	}
}
/*********************************************************************************************/
static INLINE void do_cmn(u32 op1,u32 op2)
{
__asm
	{
	mov	eax,op1
	add	eax,op2
	sets	negativeflag
	setz	zeroflag
	setnc	carryflag
	seto	overflowflag
	}
}
/*********************************************************************************************/
static INLINE u32 do_adds(u32 op1,u32 op2)
{
__asm
	{
	mov	eax,op1
	add	eax,op2
	sets	negativeflag
	setz	zeroflag
	setc	carryflag
	seto	overflowflag
	mov	op1,eax
	}
return(op1);
}
/*********************************************************************************************/
static INLINE u32 do_adcs(u32 op1,u32 op2)
{
__asm
	{
	mov	eax,op1
	clc
	cmp	carryflag,0
	jnz	doadc
	stc
doadc:
	add	eax,op2
	sets	negativeflag
	setz	zeroflag
	setc	carryflag
	seto	overflowflag
	mov	op1,eax
	}
return(op1);
}
/*********************************************************************************************/
static INLINE u32 do_subs(u32 op1,u32 op2)
{
__asm
	{
	mov	eax,op1
	sub	eax,op2
	sets	negativeflag
	setz	zeroflag
	setnc	carryflag
	seto	overflowflag
	mov	op1,eax
	}
return(op1);
}
/*********************************************************************************************/
static INLINE u32 regshift(u32 shiftdata)
{
u8 shifttype = (u8)((shiftdata >> 5) & 3);
u8 shiftamount;

if(shiftdata & 0x10)
	shiftamount = (u8)(REGS((shiftdata >> 8) & 0x1f) & 0xff);
else
	shiftamount = (u8)((shiftdata >> 7) & 0x1f);
result = REGS(shiftdata & 0xf);
switch(shifttype)
	{
	case 0: //logical left
		__asm
			{
			mov	eax,result
			mov	cl,shiftamount
			shl	eax,cl
			mov	result,eax
			}
		return(result);
	case 1: //logical right
		__asm
			{
			mov	eax,result
			mov	cl,shiftamount
			shr	eax,cl
			mov	result,eax
			}
		return(result);
	case 2: //arithmetic right
		__asm
			{
			mov	eax,result
			mov	cl,shiftamount
			sar	eax,cl
			mov	result,eax
			}
		return(result);
	case 3: //rotate right
		if(shiftamount == 0) //rotate right extended
			{
			if(carryflag)
				{
				result >>= 1;
				result |= 0x80000000;
				}
			else
				result >>= 1;
			}
		else
			{
			__asm
				{
				mov	eax,result
				mov	cl,shiftamount
				ror	eax,cl
				mov	result,eax
				}
			}
		return(result);
	}
return(0);
}
/*********************************************************************************************/
static INLINE u32 regshift_setflags(u32 shiftdata)
{
u8 shifttype = (u8)((shiftdata >> 5) & 3);
u8 shiftamount;

if(shiftdata & 0x10)
	shiftamount = (u8)(REGS((shiftdata >> 8) & 0x1f) & 0xff);
else
	shiftamount = (u8)((shiftdata >> 7) & 0x1f);
result = REGS(shiftdata & 0xf);
switch(shifttype)
	{
	case 0: //logical left
		__asm
			{
			mov	eax,result
			mov	cl,shiftamount
			shl	eax,cl
			setc	carryflag
			mov	result,eax
			}
		return(result);
	case 1: //logical right
		__asm
			{
			mov	eax,result
			mov	cl,shiftamount
			shr	eax,cl
			setc	carryflag
			mov	result,eax
			}
		return(result);
	case 2: //arithmetic right
		__asm
			{
			mov	eax,result
			mov	cl,shiftamount
			sar	eax,cl
			setc	carryflag
			mov	result,eax
			}
		return(result);
	case 3: //rotate right
		if(shiftamount == 0) //rotate right extended
			{
			if(carryflag)
				{
				carryflag = (u8)(result & 1);
				result >>= 1;
				result |= 0x80000000;
				}
			else
				{
				carryflag = (u8)(result & 1);
				result >>= 1;
				}
			}
		else
			{
			__asm
				{
				mov	eax,result
				mov	cl,shiftamount
				ror	eax,cl
				setc	carryflag
				mov	result,eax
				}
			}
		return(result);
	}
return(0);
}
/*********************************************************************************************/
static INLINE u32 immshift(u32 shiftdata)
{
u32 result;

__asm
	{
	mov	eax,shiftdata
	mov	ecx,eax
	and	eax,0ffh
	shr	ecx,8
	and	ecx,0fh
	shl	cl,1 //mul by 2
	ror	eax,cl
	mov	result,eax
	}
return(result);
}
/*********************************************************************************************/
static INLINE u32 immshift_setflags(u32 shiftdata)
{
u32 result;

__asm
	{
	mov	eax,shiftdata
	mov	ecx,eax
	and	eax,0ffh
	shr	ecx,8
	and	ecx,0fh
	shl	cl,1 //mul by 2
	ror	eax,cl
	setc	carryflag
	mov	result,eax
	}
return(result);
}
/*********************************************************************************************/
static INLINE void op_error()
{
emumessage("bad arm opcode: %08x\n",OPCODE);
execerror |= E_BADOP;
}
/*********************************************************************************************/
static INLINE void op_bx()
{
rn = (u8)(OPCODE & 0xf);
PC = REGS(rn) & ~1; //align to halfword boundary
if(REGS(rn) & 1) //go to thumb
	thumbmode();
else
	armmode();
fillpipe();
cyclesexec += 3;
}
/*********************************************************************************************/
static INLINE void op_bl_pos()
{
REGS(14) = PC - 4; //set to opcode after branch and save pc
PC += (OPCODE & 0x7fffff) << 2;
cyclesexec += 3;
fillpipe();
}
/*********************************************************************************************/
static INLINE void op_bl_neg()
{
REGS(14) = PC - 4; //set to opcode after branch and save pc
PC += 0xfe000000 | ((OPCODE & 0x7fffff) << 2);
cyclesexec += 3;
fillpipe();
}
/*********************************************************************************************/
static INLINE void op_teq_reg()
{
u32 op1 = REGS((OPCODE >> 16) & 0xf);
u32 op2 = regshift_setflags(OPCODE & 0xfff);

op1 ^= op2;
CHECKNZ_32(op1);
cyclesexec += 3;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_teq_imm()
{
u32 op1 = REGS((OPCODE >> 16) & 0xf);
u32 op2 = immshift_setflags(OPCODE & 0xfff);

result = op1 ^ op2;
CHECKNZ_32(result);
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_cmp_reg()
{
do_cmp(REGS((OPCODE >> 16) & 0xf),regshift_setflags(OPCODE & 0xfff));
cyclesexec += 2; //verified
incpipe();
}
/*********************************************************************************************/
static INLINE void op_cmp_imm()
{
do_cmp(REGS((OPCODE >> 16) & 0xf),immshift_setflags(OPCODE & 0xfff));
cyclesexec += 1; //verified
incpipe();
}
/*********************************************************************************************/
static INLINE void op_cmn_reg()
{
do_cmn(REGS((OPCODE >> 16) & 0xf),regshift_setflags(OPCODE & 0xfff));
cyclesexec += 2; //verified
incpipe();
}
/*********************************************************************************************/
static INLINE void op_cmn_imm()
{
do_cmn(REGS((OPCODE >> 16) & 0xf),immshift_setflags(OPCODE & 0xfff));
cyclesexec += 1; //verified
incpipe();
}
/*********************************************************************************************/
static INLINE void op_tst_reg()
{
u32 tmp;

tmp = REGS((OPCODE >> 16) & 0xf) & REGS((OPCODE >> 12) & 0xf);
CHECKNZ_32(tmp);
cyclesexec += 3;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_tst_imm()
{
u32 tmp;

tmp = REGS((OPCODE >> 16) & 0xf) & immshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(tmp);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_mov_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = regshift(OPCODE & 0xfff);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_movs_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = regshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 2; //verified
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2; //verified
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_mov_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = immshift(OPCODE & 0xfff);
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_movs_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = immshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_mvn_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = ~regshift(OPCODE & 0xfff);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_mvns_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = ~regshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_mvn_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = ~immshift(OPCODE & 0xfff);
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_mvns_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = ~immshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_and_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) & regshift(OPCODE & 0xfff);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_ands_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) & regshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_and_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) & immshift(OPCODE & 0xfff);
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_ands_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) & immshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_mul()
{
REGS((OPCODE >> 16) & 0xf) = REGS(OPCODE & 0xf) * REGS((OPCODE >> 8) & 0xf);
incpipe();
}
/*********************************************************************************************/
static INLINE void op_muls()
{
rd = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = REGS(OPCODE & 0xf) * REGS((OPCODE >> 8) & 0xf);
CHECKNZ_32(REGS(rd));
incpipe();
}
/*********************************************************************************************/
static INLINE void op_mla()
{
REGS((OPCODE >> 16) & 0xf) = (REGS(OPCODE & 0xf) * REGS((OPCODE >> 8) & 0xf)) + REGS((OPCODE >> 12) & 0xf);
incpipe();
}
/*********************************************************************************************/
static INLINE void op_mlas()
{
rd = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (REGS(OPCODE & 0xf) * REGS((OPCODE >> 8) & 0xf)) + REGS((OPCODE >> 12) & 0xf);
CHECKNZ_32(REGS(rd));
incpipe();
}
/*********************************************************************************************/
static INLINE void op_add_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_adds_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = do_adds(REGS((OPCODE >> 16) & 0xf),regshift_setflags(OPCODE & 0xfff));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_add_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) + immshift(OPCODE & 0xfff);
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_adds_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = do_adds(REGS((OPCODE >> 16) & 0xf),immshift_setflags(OPCODE & 0xfff));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_adc_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff);
if(carryflag)
	REGS(rd)++;
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_adcs_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = do_adcs(REGS((OPCODE >> 16) & 0xf),regshift_setflags(OPCODE & 0xfff));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_adc_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) + immshift(OPCODE & 0xfff);
if(carryflag)
	REGS(rd)++;
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_adcs_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = do_adcs(REGS((OPCODE >> 16) & 0xf),immshift_setflags(OPCODE & 0xfff));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_msr_reg_cpsr() //this opcode is all fucked up
{
if(OPCODE & 0x00001000) //only fuck with mode
	{
	if((CPSR & 0x1f) != USER)
		{
		CPSR = REGS(OPCODE & 0xf);
		lazyflags(CPSR);
		arm7tdmi_modechange((u8)(CPSR & 0x1f));
		}
	}
else
	{
	if((CPSR & 0x1f) == USER) //change only the flags
		{
		notlazyflags(CPSR);
		CPSR &= 0x0fffffff;
		CPSR |= REGS(OPCODE & 0xf) & 0xf0000000;
		lazyflags(CPSR);
		}
	else
		{
		CPSR = REGS(OPCODE & 0xf);
		lazyflags(CPSR);
		arm7tdmi_modechange((u8)(CPSR & 0x1f));
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_msr_reg_spsr()
{
SPSR = REGS(OPCODE & 0xf);
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_bic_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) &= REGS((OPCODE >> 16) & 0xf) & ~immshift(OPCODE & 0xfff);
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_bics_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) &= REGS((OPCODE >> 16) & 0xf) & ~immshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_bic_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) &= REGS((OPCODE >> 16) & 0xf) & ~regshift(OPCODE & 0xfff);
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_bics_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) &= REGS((OPCODE >> 16) & 0xf) & ~regshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_ldm_pre_down_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;
u32 addr = REGS((OPCODE >> 16) & 0xf);

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		REGS(i) = read32(addr);
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2; //verified
if(OPCODE & 0x00008000) //pc
	{
	PC &= ~1;
	cyclesexec += 2; //verified
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_ldm_post_down_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;
u32 addr = REGS((OPCODE >> 16) & 0xf);

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32(addr);
		addr -= 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2; //verified
if(OPCODE & 0x00008000) //pc
	{
	PC &= ~1;
	cyclesexec += 2; //verified
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_ldm_pre_up_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;
u32 addr = REGS((OPCODE >> 16) & 0xf);

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		REGS(i) = read32(addr);
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2; //verified
if(OPCODE & 0x00008000) //pc
	{
	PC &= ~1;
	cyclesexec += 2; //verified
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_ldm_post_up_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;
u32 addr = REGS((OPCODE >> 16) & 0xf);

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32(addr);
		addr += 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2; //verified
if(OPCODE & 0x00008000) //pc
	{
	PC &= ~1;
	cyclesexec += 2; //verified
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_ldm_post_up_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;
u32 addr = REGS((OPCODE >> 16) & 0xf);

for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32(addr);
		addr += 4;
		cyclesexec++;
		}
	}
cyclesexec += 2; //verified
if(OPCODE & 0x00008000) //pc
	{
	PC &= ~1;
	cyclesexec += 2; //verified
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_stm_pre_down_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		REGS(rn) -= 4;
		write32(REGS(rn),REGS(i));
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_stm_post_down_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		write32(REGS(rn),REGS(i));
		REGS(rn) -= 4;
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_stm_pre_up_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		REGS(rn) += 4;
		write32(REGS(rn),REGS(i));
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_stm_post_up_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		write32(REGS(rn),REGS(i));
		REGS(rn) += 4;
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_stm_post_up_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;
u32 addr = REGS((OPCODE >> 16) & 0xf);

for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		write32(addr,REGS(i));
		addr += 4;
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_b_pos()
{
PC += (OPCODE & 0x7fffff) << 2;
cyclesexec += 3;
fillpipe();
}
/*********************************************************************************************/
static INLINE void op_b_neg()
{
PC += 0xfc000000 | ((OPCODE & 0xffffff) << 2);
cyclesexec += 3;
fillpipe();
}
/*********************************************************************************************/
static INLINE void op_mrs_cpsr_reg()
{
CPSR = notlazyflags(CPSR);
REGS((OPCODE >> 12) & 0xf) = CPSR;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_mrs_spsr_reg()
{
REGS((OPCODE >> 12) & 0xf) = SPSR;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static INLINE void op_rsb_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = regshift(OPCODE & 0xfff) - REGS((OPCODE >> 16) & 0xf);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_rsbs_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = do_subs(regshift_setflags(OPCODE & 0xfff),REGS((OPCODE >> 16) & 0xf));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_rsb_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = immshift(OPCODE & 0xfff) - REGS((OPCODE >> 16) & 0xf);
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_rsbs_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = do_subs(immshift_setflags(OPCODE & 0xfff),REGS((OPCODE >> 16) & 0xf));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_sub_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_subs_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = do_subs(REGS((OPCODE >> 16) & 0xf),regshift_setflags(OPCODE & 0xfff));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_sub_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) - immshift(OPCODE & 0xfff);
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_subs_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = do_subs(REGS((OPCODE >> 16) & 0xf),immshift_setflags(OPCODE & 0xfff));
cyclesexec += 1;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_orr_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) | regshift(OPCODE & 0xfff);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_orrs_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) | regshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_orr_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) | immshift(OPCODE & 0xfff);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_orrs_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) | immshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_eor_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) ^ regshift(OPCODE & 0xfff);
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_eors_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
REGS(rd) = REGS((OPCODE >> 16) & 0xf) ^ regshift_setflags(OPCODE & 0xfff);
CHECKNZ_32(REGS(rd));
cyclesexec += 2;
if(rd == 15) //pc write
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static INLINE void op_swi()
{
/*u32 pc = PC;
u32 cpsr = CPSR;

arm7tdmi_modechange(0x13);
REGS(14) = pc;
SPSR = cpsr;
cyclesexec += 3;
fillpipe();*/
cyclesexec += 3;//skip the opcode for now
incpipe();
}
/*********************************************************************************************/
u32 translate_thumb(u16 op)
{
u32 armop;

armop = 0xe6000010; //undefined opcode
switch(op >> 8)
	{
	case 0x00: //lsl rs,rs,imm = movs rd,rs,lsl imm
	case 0x01:
	case 0x02:
	case 0x03:
	case 0x04:
	case 0x05:
	case 0x06:
	case 0x07:
		armop = 0xe1b00000 | ((op & 0x07c0) << 1) | ((op & 0x0038) >> 3) | ((op & 0x0007) << 12);
		break;
	case 0x08: //lsr rs,rs,imm = movs rd,rs,lsr imm
	case 0x09:
	case 0x0a:
	case 0x0b:
	case 0x0c:
	case 0x0d:
	case 0x0e:
	case 0x0f:
		armop = 0xe1b00020 | ((op & 0x07c0) << 1) | ((op & 0x0038) >> 3) | ((op & 0x0007) << 12);
		break;
	case 0x10: //asr rs,rs,imm = movs rd,rs,asr imm
	case 0x11:
	case 0x12:
	case 0x13:
	case 0x14:
	case 0x15:
	case 0x16:
	case 0x17:
		armop = 0xe1b00040 | ((op & 0x07c0) << 1) | ((op & 0x0038) >> 3) | ((op & 0x0007) << 12);
		break;
	case 0x18: //add rd,rs,rn = adds rd,rs,rn
	case 0x19:
		armop = 0xe0900000 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x1a: //sub rd,rs,rn = subs rd,rs,rn
	case 0x1b:
		armop = 0xe0500000 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x1c: //add rd,rs,imm = adds rd,rs,imm
	case 0x1d:
		armop = 0xe2900000 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x1e: //sub rd,rs,imm = subs rd,rs,imm
	case 0x1f:
		armop = 0xe2500000 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x20: //mov rd,imm = movs rd,imm
	case 0x21:
	case 0x22:
	case 0x23:
	case 0x24:
	case 0x25:
	case 0x26:
	case 0x27:
		armop = 0xe3b00000 | ((op & 0x0700) << 8) | ((op & 0x0700) << 4) | (op & 0x00ff);
		break;
	case 0x28: //cmp rd,imm = cmp rd,imm
	case 0x29:
	case 0x2a:
	case 0x2b:
	case 0x2c:
	case 0x2d:
	case 0x2e:
	case 0x2f:
		armop = 0xe3500000 | ((op & 0x0700) << 8) | ((op & 0x0700) << 4) | (op & 0x00ff);
		break;
	case 0x30: //add rd,imm = adds rd,rd,imm
	case 0x31:
	case 0x32:
	case 0x33:
	case 0x34:
	case 0x35:
	case 0x36:
	case 0x37:
		armop = 0xe2900000 | ((op & 0x0700) << 8) | ((op & 0x0700) << 4) | (op & 0x00ff);
		break;
	case 0x38: //sub rd,imm = subs rd,rd,imm
	case 0x39:
	case 0x3a:
	case 0x3b:
	case 0x3c:
	case 0x3d:
	case 0x3e:
	case 0x3f:
		armop = 0xe2500000 | ((op & 0x0700) << 8) | ((op & 0x0700) << 4) | (op & 0x00ff);
		break;
	case 0x40:
		if((op & 0xc0) == 0x00) //and rd,rs = ands rd,rd,rs
			armop = 0xe0100000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		else if((op & 0xc0) == 0x40) //eor rd,rs = eors rd,rd,rs
			armop = 0xe0300000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		else if((op & 0xc0) == 0x80) //lsl rd,rs = movs rd,rd,lsl rs
			armop = 0xe1b00010 | ((op & 0x0038) << 5) | ((op & 7) << 12) | (op & 7);
		else //lsr rd,rs = movs rd,rd,lsr rs
			armop = 0xe1b00030 | ((op & 0x0038) << 5) | ((op & 7) << 12) | (op & 7);
		break;
	case 0x41:
		if((op & 0xc0) == 0x00) //asr rd,rs = movs rd,rd,asr rs
			armop = 0xe1b00050 | ((op & 0x0038) << 5) | ((op & 7) << 12) | (op & 7);
		else if((op & 0xc0) == 0x40) //ror rd,rs = movs rd,rd,ror rs
			armop = 0xe0b00000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		else if((op & 0xc0) == 0x80) //ror rd,rs = movs rd,rd,ror rs
			armop = 0xe0d00000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		else //ror rd,rs = movs rd,rd,ror rs
			armop = 0xe1b00070 | ((op & 0x0038) << 5) | ((op & 7) << 12) | (op & 7);
		break;
	case 0x42:
		if((op & 0xc0) == 0x00) //tst rd,rs = tst rd,rs
			armop = 0xe1100000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		else if((op & 0xc0) == 0x40) //neg rd,rs = rsbs rd,rs
			armop = 0xe2700000 | ((op & 0x0038) << 13) | ((op & 7) << 12);
		else if((op & 0xc0) == 0x80) //cmp rd,rs = cmp rd,rs
			armop = 0xe1500000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		else //cmn rd,rs = cmn rd,rs
			armop = 0xe1700000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		break;
	case 0x43:
		if((op & 0xc0) == 0x00) //orr rd,rs = orrs rd,rs
			armop = 0xe1900000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		else if((op & 0xc0) == 0x40) //mul rd,rs = muls rd,rd,rs
			armop = 0xe0100090 | ((op & 0x0038) >> 3) | ((op & 7) << 8) | ((op & 7) << 16);
		else if((op & 0xc0) == 0x80) //bic rd,rs = bics rd,rd,rs
			armop = 0xe1d00000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		else //mvn rd,rs = mvns rd,rs
			armop = 0xe1f00000 | ((op & 0x0038) >> 3) | ((op & 7) << 12) | ((op & 7) << 16);
		break;
	case 0x44:
		if((op & 0xc0) == 0x40) //add rd,hs = add rd,rd,rs
			armop = 0xe0800000 | ((op & 0x0007) << 16) | ((op & 0x0007) << 12) | (((op & 0x0038) >> 3) | 8);
		else if((op & 0xc0) == 0x80) //add hd,rs = add rd,rd,rs
			armop = 0xe0800000 | (((op & 0x0007) | 8) << 16) | (((op & 0x0007) | 8) << 12) | ((op & 0x0038) >> 3);
		else if((op & 0xc0) == 0xc0) //add hd,hs = add rd,rd,rs
			armop = 0xe0800000 | (((op & 0x0007) | 8) << 16) | (((op & 0x0007) | 8) << 12) | (((op & 0x0038) >> 3) | 8);
		break;
	case 0x45:
		if((op & 0xc0) == 0x40) //cmp rd,hs = cmp rd,rs
			armop = 0xe1500000 | ((op & 0x0007) << 16) | ((op & 0x0007) << 12) | (((op & 0x0038) >> 3) | 8);
		else if((op & 0xc0) == 0x80) //cmp hd,rs = cmp rd,rs
			armop = 0xe1500000 | (((op & 0x0007) | 8) << 16) | (((op & 0x0007) | 8) << 12) | ((op & 0x0038) >> 3);
		else if((op & 0xc0) == 0xc0) //cmp hd,hs = cmp rd,rs
			armop = 0xe1500000 | (((op & 0x0007) | 8) << 16) | (((op & 0x0007) | 8) << 12) | (((op & 0x0038) >> 3) | 8);
		break;
	case 0x46:
		if((op & 0xc0) == 0x40) //mov rd,hs = movs rd,rs
			armop = 0xe1a00000 | ((op & 0x0007) << 16) | ((op & 0x0007) << 12) | (((op & 0x0038) >> 3) | 8);
		else if((op & 0xc0) == 0x80) //mov hd,rs = movs rd,rs
			armop = 0xe1a00000 | (((op & 0x0007) | 8) << 16) | (((op & 0x0007) | 8) << 12) | ((op & 0x0038) >> 3);
		else if((op & 0xc0) == 0xc0) //mov hd,hs = movs rd,rs
			armop = 0xe1a00000 | (((op & 0x0007) | 8) << 16) | (((op & 0x0007) | 8) << 12) | (((op & 0x0038) >> 3) | 8);
		break;
	case 0x47:
		if((op & 0x80) == 0)
			{
			if(op & 0x0800)
				armop = 0xe6000010; //undefined opcode
			else //bx rs
				armop = 0xe12fff10 | ((op >> 3) & 0xf);
			}
		break;
	case 0x48: //ldr rd,[r15,#imm] = ldr rd,[r15,#imm]
	case 0x49:
	case 0x4a:
	case 0x4b:
	case 0x4c:
	case 0x4d:
	case 0x4e:
	case 0x4f:
		armop = 0xe59f0000 | ((op & 0x0700) << 4) | ((op & 0x00ff) << 2);
		break;
	case 0x50: //str rd,[rb,ro] = str rd,[rb,ro]
	case 0x51:
		armop = 0xe7800000 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x52: //strh rd,[rb,ro] = strh rd,[rb,ro]
	case 0x53:
		armop = 0xe18000b0 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x54: //strb rd,[rb,ro] = strb rd,[rb,ro]
	case 0x55:
		armop = 0xe7c00000 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x56: //ldsb rd,[rb,ro] = ldrsb rd,[rb,ro]
	case 0x57:
		armop = 0xe19000d0 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x58: //ldr rd,[rb,ro] = ldr rd,[rb,ro]
	case 0x59:
		armop = 0xe7900000 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x5a: //ldrh rd,[rb,ro] = ldrh rd,[rb,ro]
	case 0x5b:
		armop = 0xe19000b0 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x5c: //ldrb rd,[rb,ro] = ldrb rd,[rb,ro]
	case 0x5d:
		armop = 0xe7d00000 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x5e: //ldsh rd,[rb,ro] = ldrsh rd,[rb,ro]
	case 0x5f:
		armop = 0xe19000f0 | ((op & 0x01c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x60: //str rd,[rb,imm] = str rd,[rb,imm]
	case 0x61:
	case 0x62:
	case 0x63:
	case 0x64:
	case 0x65:
	case 0x66:
	case 0x67:
		armop = 0xe5800000 | ((op & 0x07c0) >> 4) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x68: //ldr rd,[rb,imm] = ldr rd,[rb,imm]
	case 0x69:
	case 0x6a:
	case 0x6b:
	case 0x6c:
	case 0x6d:
	case 0x6e:
	case 0x6f:
		armop = 0xe5900000 | ((op & 0x07c0) >> 4) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x70: //strb rd,[rb,imm] = strb rd,[rb,imm]
	case 0x71:
	case 0x72:
	case 0x73:
	case 0x74:
	case 0x75:
	case 0x76:
	case 0x77:
		armop = 0xe5c00000 | ((op & 0x07c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x78: //ldrb rd,[rb,imm] = ldrb rd,[rb,imm]
	case 0x79:
	case 0x7a:
	case 0x7b:
	case 0x7c:
	case 0x7d:
	case 0x7e:
	case 0x7f:
		armop = 0xe5d00000 | ((op & 0x07c0) >> 6) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x80: //strh rd,[rb,#imm] = strh rd,[rb,#imm]
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
		armop = 0xe1c000b0 | ((op & 0x0600) >> 1) | ((op & 0x01c0) >> 5) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x88: //ldrh rd,[rb,#imm] = ldrh rd,[rb,#imm]
	case 0x89:
	case 0x8a:
	case 0x8b:
	case 0x8c:
	case 0x8d:
	case 0x8e:
	case 0x8f:
		armop = 0xe1d000b0 | ((op & 0x0600) >> 1) | ((op & 0x01c0) >> 5) | ((op & 0x0038) << 13) | ((op & 0x0007) << 12);
		break;
	case 0x90: //str rd,[r13,#imm] = str rd,[r13,#imm]
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
		armop = 0xe58d0000 | ((op & 0x0700) << 4) | ((op & 0x00ff) << 2);
		break;
	case 0x98: //ldr rd,[r13,#imm] = ldr rd,[r13,#imm]
	case 0x99:
	case 0x9a:
	case 0x9b:
	case 0x9c:
	case 0x9d:
	case 0x9e:
	case 0x9f:
		armop = 0xe59d0000 | ((op & 0x0700) << 4) | ((op & 0x00ff) << 2);
		break;
	case 0xa0: //add rd,pc,imm = add rd,r15,imm
	case 0xa1:
	case 0xa2:
	case 0xa3:
	case 0xa4:
	case 0xa5:
	case 0xa6:
	case 0xa7:
		armop = 0xe28f0f00 | ((op & 0x0700) << 4) | (op & 0xff);
		break;
	case 0xa8: //add rd,sp,imm = add rd,r13,imm
	case 0xa9:
	case 0xaa:
	case 0xab:
	case 0xac:
	case 0xad:
	case 0xae:
	case 0xaf:
		armop = 0xe28d0f00 | ((op & 0x0700) << 4) | (op & 0xff);
		break;
	case 0xb0:
		if(op & 0x0080) //add sp,#-imm = sub r13,r13,#imm
			armop = 0xe24ddf00 | (op & 0x007f);
		else //add sp,#+imm = add r13,r13,#imm
			armop = 0xe28ddf00 | (op & 0x007f);
		break;
	case 0xb4: //push {rlist} = stmdb r13!,{rlist}
		armop = 0xe92d0000 | (op & 0x00ff);
		break;
	case 0xb5: //push {rlist,r14} = stmdb r13!,{rlist,r14}
		armop = 0xe92d4000 | (op & 0x00ff);
		break;
	case 0xbc: //pop {rlist} = ldmia r13!,{rlist}
		armop = 0xe8bd0000 | (op & 0x00ff);
		break;
	case 0xbd: //pop {rlist,r15} = ldmia r13!,{rlist,r15}
		armop = 0xe8bd8000 | (op & 0x00ff);
		break;
	case 0xc0: //stmia rb!,{rlist} = stmia rb!,{rlist}
	case 0xc1:
	case 0xc2:
	case 0xc3:
	case 0xc4:
	case 0xc5:
	case 0xc6:
	case 0xc7:
		armop = 0xe8a00000 | ((op & 0x0700) << 8) | (op & 0x00ff);
		break;
	case 0xc8: //ldmia rb!,{rlist} = ldmia rb!,{rlist}
	case 0xc9:
	case 0xca:
	case 0xcb:
	case 0xcc:
	case 0xcd:
	case 0xce:
	case 0xcf:
		armop = 0xe8b00000 | ((op & 0x0700) << 8) | (op & 0x00ff);
		break;
	case 0xd0: //beq offset = beq offset
		armop = 0x00000000 | op;
		break;
	case 0xd1: //bne offset = bne offset
		armop = 0x10000000 | op;
		break;
	case 0xd2: //bcs offset = bcs offset
		armop = 0x20000000 | op;
		break;
	case 0xd3: //bcc offset = bcc offset
		armop = 0x30000000 | op;
		break;
	case 0xd4: //bmi offset = bmi offset
		armop = 0x40000000 | op;
		break;
	case 0xd5: //bpl offset = bpl offset
		armop = 0x50000000 | op;
		break;
	case 0xd6: //bvs offset = bpl offset
		armop = 0x60000000 | op;
		break;
	case 0xd7: //bvc offset = bpl offset
		armop = 0x70000000 | op;
		break;
	case 0xd8: //bhi offset = bpl offset
		armop = 0x80000000 | op;
		break;
	case 0xd9: //bls offset = bpl offset
		armop = 0x90000000 | op;
		break;
	case 0xda: //bge offset = bge offset
		armop = 0xa0000000 | op;
		break;
	case 0xdb: //blt offset = blt offset
		armop = 0xb0000000 | op;
		break;
	case 0xdc: //bgt offset = bgt offset
		armop = 0xc0000000 | op;
		break;
	case 0xdd: //ble offset = ble offset
		armop = 0xd0000000 | op;
		break;
	case 0xde: //b offset = b offset
		armop = 0xe0000000 | op;
		break;
	case 0xdf: //swi value
		armop = 0xef000000 | (op & 0xff);
		break;
	case 0xe0: //b label = b label
	case 0xe1:
	case 0xe2:
	case 0xe3:
	case 0xe4:
	case 0xe5:
	case 0xe6:
	case 0xe7:
		armop = 0xe0000000 | op;
		break;
	case 0xf0: //bl (h=0)
	case 0xf1:
	case 0xf2:
	case 0xf3:
	case 0xf4:
	case 0xf5:
	case 0xf6:
	case 0xf7:
		armop = 0xf0000000 | op;
		break;
	case 0xf8: //bl (h=1)
	case 0xf9:
	case 0xfa:
	case 0xfb:
	case 0xfc:
	case 0xfd:
	case 0xfe:
	case 0xff:
		armop = 0xf0000000 | op;
		break;
	}
return(armop);
}
/*********************************************************************************************/
static INLINE u32 translate_thumb_opcode(u16 op,u32 *didfunc)
{
u32 armop;

armop = thumb_to_arm[op];
if(((op >> 8) & 0xf0) >= 0xd0)
	*didfunc = 1;
else
	*didfunc = 0;
return(armop);
}
/*********************************************************************************************/
static INLINE void thumb_branch()
{
if(OPCODE & 0x0080) //negative
	PC += 0xfffffe00 | ((OPCODE & 0xff) << 1);
else //positive
	PC += (OPCODE & 0xff) << 1;
cyclesexec += 3;
fillpipe();
}
/*********************************************************************************************/
static INLINE void thumb_opcode()
{
if((opcode & 0xf0000000) == 0xf0000000)
	{
	if(opcode & 0x0800) //second half
		{
		u32 temp = PC - 2;

		PC = (REGS(14) + ((OPCODE & 0x7ff) << 1));
		REGS(14) = temp | 1;
		cyclesexec += 2;
		fillpipe();
		}
	else
		{
		REGS(14) = PC + ((OPCODE & 0x7ff) << 12) + ((OPCODE & 0x0400)?0xff800000:0);
		cyclesexec += 2;//dunno how many cycles each half is, but its 4 total, so ill do 2 each
		incpipe();
		}
	}
else
	{
	if((opcode & 0x0000f000) == 0x0000e000)
		{
		if((opcode & 0x0400) == 0x0400)
			PC += ((opcode & 0x3ff) << 1) | 0xfffff800;
		else
			PC += (opcode & 0x3ff) << 1;
		cyclesexec += 3;//verfied
		fillpipe();
		}
	else
		{
		switch(OPCODE >> 28)
			{
			case 0x0:if(zeroflag){thumb_branch();return;}break;
			case 0x1:if(zeroflag == 0){thumb_branch();return;}break;
			case 0x2:if(carryflag){thumb_branch();return;}break;
			case 0x3:if(carryflag == 0){thumb_branch();return;}break;
			case 0x4:if(negativeflag){thumb_branch();return;}break;
			case 0x5:if(negativeflag == 0){thumb_branch();return;}break;
			case 0x6:if(overflowflag){thumb_branch();return;}break;
			case 0x7:if(overflowflag == 0){thumb_branch();return;}break;
			case 0x8:if(carryflag && zeroflag == 0){thumb_branch();return;}break;
			case 0x9:if(carryflag == 0 && zeroflag){thumb_branch();return;}break;
			case 0xa:if(negativeflag == overflowflag){thumb_branch();return;}break;
			case 0xb:if(negativeflag != overflowflag){thumb_branch();return;}break;
			case 0xc:if(zeroflag == 0 && (negativeflag == overflowflag)){thumb_branch();return;}break;
			case 0xd:if(zeroflag || (negativeflag != overflowflag)){thumb_branch();return;}break;
			case 0xe:thumb_branch();return;
			}
		cyclesexec += 1; //does skipping opcode eat a cycle?
		incpipe();
		}
	}
}
/*********************************************************************************************/
//emumessage("op $59: loading from %08x, got %08x, rotate right %d, left %d\n",addr & ~3,REGS(rd),addr,32-addr);









void op_strh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16(REGS(rn),(u16)REGS(rd));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16(REGS(rn));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8(REGS(rn));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16(REGS(rn));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16(REGS(rn),(u16)REGS(rd));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16(REGS(rn));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8(REGS(rn));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16(REGS(rn));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16(REGS(rn),(u16)REGS(rd));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16(REGS(rn));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8(REGS(rn));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16(REGS(rn));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16(REGS(rn),(u16)REGS(rd));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16(REGS(rn));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8(REGS(rn));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16(REGS(rn));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_swp_word()
{
u32 addr = REGS((OPCODE >> 16) & 0xf);

REGS((OPCODE >> 12) & 0xf) = read32(addr);
write32(addr,REGS(OPCODE & 0xf));
cyclesexec += 4;
incpipe();
}
/*********************************************************************************************/
void op_strh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) - REGS(OPCODE & 0xf)),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) -= REGS(OPCODE & 0xf)),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_swp_byte()
{
u32 addr = REGS((OPCODE >> 16) & 0xf);

REGS((OPCODE >> 12) & 0xf) = (u32)read8(addr);
write8(addr,(u8)REGS(OPCODE & 0xf));
cyclesexec += 4;
incpipe();
}
/*********************************************************************************************/
void op_strh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) + REGS(OPCODE & 0xf)),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) += REGS(OPCODE & 0xf)),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write32(REGS(rn),REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) -= ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write8(REGS(rn),(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8(addr);
REGS(rn) -= ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write32(REGS(rn),REGS((OPCODE >> 12) & 0xf));
REGS(rn) += (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) += ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write8(REGS(rn),(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) += (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8(addr);
REGS(rn) += ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_pre_down_nowb()
{
write32((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_pre_down_wb()
{
write32((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_pre_down_nowb()
{
write8((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_pre_down_wb()
{
write8((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_pre_up_nowb()
{
write32((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_pre_up_wb()
{
write32((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_pre_up_nowb()
{
write8((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_pre_up_wb()
{
write8((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write32(REGS(rn),REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) -= regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write8(REGS(rn),(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8(addr);
REGS(rn) -= regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write32(REGS(rn),REGS((OPCODE >> 12) & 0xf));
REGS(rn) += regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) += regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write8(REGS(rn),(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) += regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8(addr);
REGS(rn) += regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_pre_down_nowb()
{
write32((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_pre_down_wb()
{
write32((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_pre_down_nowb()
{
write8((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_pre_down_wb()
{
write8((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_pre_up_nowb()
{
write32((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_pre_up_wb()
{
write32((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_pre_up_nowb()
{
write8((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_pre_up_wb()
{
write8((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/









void fill_arm_func_table_entry(u16 poo)
{
ops[poo] = op_error; //in case this function has "extra features" :P
switch((poo >> 4) & 0xff)
	{
	case 0x00:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_mul;break;
			case 0xb:ops[poo] = op_strh_post_down_reg;break;
			case 0xd:ops[poo] = op_strh_post_down_reg;break;
			case 0xf:ops[poo] = op_strh_post_down_reg;break;
			default:ops[poo] = op_and_reg;break;
			}
		break;
	case 0x01:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_muls;break;
			case 0xb:ops[poo] = op_ldrh_post_down_reg;break;
			case 0xd:ops[poo] = op_ldrsb_post_down_reg;break;
			case 0xf:ops[poo] = op_ldrsh_post_down_reg;break;
			default:ops[poo] = op_ands_reg;break;
			}
		break;
	case 0x02:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_mla;break;
			case 0xb:ops[poo] = op_strh_post_down_reg;break;
			case 0xd:ops[poo] = op_strh_post_down_reg;break;
			case 0xf:ops[poo] = op_strh_post_down_reg;break;
			default:ops[poo] = op_eor_reg;break;
			}
		break;
	case 0x03:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_mlas;break;
			case 0xb:ops[poo] = op_ldrh_post_down_reg;break;
			case 0xd:ops[poo] = op_ldrsb_post_down_reg;break;
			case 0xf:ops[poo] = op_ldrsh_post_down_reg;break;
			default:ops[poo] = op_eors_reg;break;
			}
		break;
	case 0x04:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_down_imm;break;
			case 0xd:ops[poo] = op_strh_post_down_imm;break;
			case 0xf:ops[poo] = op_strh_post_down_imm;break;
			default:ops[poo] = op_sub_reg;break;
			}
		break;
	case 0x05:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_down_imm;break;
			case 0xd:ops[poo] = op_ldrsb_post_down_imm;break;
			case 0xf:ops[poo] = op_ldrsh_post_down_imm;break;
			default:ops[poo] = op_subs_reg;break;
			}
		break;
	case 0x06:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_down_imm;break;
			case 0xd:ops[poo] = op_strh_post_down_imm;break;
			case 0xf:ops[poo] = op_strh_post_down_imm;break;
			default:ops[poo] = op_rsb_reg;break;
			}
		break;
	case 0x07:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_down_imm;break;
			case 0xd:ops[poo] = op_ldrsb_post_down_imm;break;
			case 0xf:ops[poo] = op_ldrsh_post_down_imm;break;
			default:ops[poo] = op_rsbs_reg;break;
			}
		break;
	case 0x08:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_up_reg;break;
			case 0xd:ops[poo] = op_strh_post_up_reg;break;
			case 0xf:ops[poo] = op_strh_post_up_reg;break;
			default:ops[poo] = op_add_reg;break;
			}
		break;
	case 0x09:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_up_reg;break;
			case 0xd:ops[poo] = op_ldrsb_post_up_reg;break;
			case 0xf:ops[poo] = op_ldrsh_post_up_reg;break;
			default:ops[poo] = op_adds_reg;break;
			}
		break;
	case 0x0a:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_up_reg;break;
			case 0xd:ops[poo] = op_strh_post_up_reg;break;
			case 0xf:ops[poo] = op_strh_post_up_reg;break;
			default:ops[poo] = op_adc_reg;break;
			}
		break;
	case 0x0b:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_up_reg;break;
			case 0xd:ops[poo] = op_ldrsb_post_up_reg;break;
			case 0xf:ops[poo] = op_ldrsh_post_up_reg;break;
			default:ops[poo] = op_adcs_reg;break;
			}
		break;
	case 0x0c:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_up_imm;break;
			case 0xd:ops[poo] = op_strh_post_up_imm;break;
			case 0xf:ops[poo] = op_strh_post_up_imm;break;
			default:ops[poo] = op_error;break;
			}
		break;
	case 0x0d:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_up_imm;break;
			case 0xd:ops[poo] = op_ldrsb_post_up_imm;break;
			case 0xf:ops[poo] = op_ldrsh_post_up_imm;break;
			default:ops[poo] = op_error;break;
			}
		break;
	case 0x0e:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_up_imm;break;
			case 0xd:ops[poo] = op_strh_post_up_imm;break;
			case 0xf:ops[poo] = op_strh_post_up_imm;break;
			default:ops[poo] = op_error;break;
			}
		break;
	case 0x0f:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_up_imm;break;
			case 0xd:ops[poo] = op_ldrsb_post_up_imm;break;
			case 0xf:ops[poo] = op_ldrsh_post_up_imm;break;
			default:ops[poo] = op_error;break;
			}
		break;
	case 0x10:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_swp_word;break;
			case 0xb:ops[poo] = op_strh_pre_down_reg_nowb;break;
			case 0xd:ops[poo] = op_strh_pre_down_reg_nowb;break;
			case 0xf:ops[poo] = op_strh_pre_down_reg_nowb;break;
			default:ops[poo] = op_mrs_cpsr_reg;break;
			}
		break;
	case 0x11:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_down_reg_nowb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_down_reg_nowb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_down_reg_nowb;break;
			default:ops[poo] = op_tst_reg;break;
			}
		break;
	case 0x12:
		switch(poo & 0xf)
			{
			case 0x1:ops[poo] = op_bx;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_down_reg_wb;break;
			case 0xd:ops[poo] = op_strh_pre_down_reg_wb;break;
			case 0xf:ops[poo] = op_strh_pre_down_reg_wb;break;
			default:ops[poo] = op_msr_reg_cpsr;break;
			}
		break;
	case 0x13:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_down_reg_wb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_down_reg_wb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_down_reg_wb;break;
			default:ops[poo] = op_teq_reg;break;
			}
		break;
	case 0x14:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_swp_byte;break;
			case 0xb:ops[poo] = op_strh_pre_down_imm_nowb;break;
			case 0xd:ops[poo] = op_strh_pre_down_imm_nowb;break;
			case 0xf:ops[poo] = op_strh_pre_down_imm_nowb;break;
			default:ops[poo] = op_mrs_spsr_reg;break;
			}
		break;
	case 0x15:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_down_imm_nowb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_down_imm_nowb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_down_imm_nowb;break;
			default:ops[poo] = op_cmp_reg;break;
			}
		break;
	case 0x16:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_down_imm_wb;break;
			case 0xd:ops[poo] = op_strh_pre_down_imm_wb;break;
			case 0xf:ops[poo] = op_strh_pre_down_imm_wb;break;
			default:ops[poo] = op_msr_reg_spsr;break;
			}
		break;
	case 0x17:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_down_imm_wb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_down_imm_wb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_down_imm_wb;break;
			default:ops[poo] = op_cmn_reg;break;
			}
		break;
	case 0x18:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_up_reg_nowb;break;
			case 0xd:ops[poo] = op_strh_pre_up_reg_nowb;break;
			case 0xf:ops[poo] = op_strh_pre_up_reg_nowb;break;
			default:ops[poo] = op_orr_reg;break;
			}
		break;
	case 0x19:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_up_reg_nowb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_up_reg_nowb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_up_reg_nowb;break;
			default:ops[poo] = op_orrs_reg;break;
			}
		break;
	case 0x1a:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_up_reg_wb;break;
			case 0xd:ops[poo] = op_strh_pre_up_reg_wb;break;
			case 0xf:ops[poo] = op_strh_pre_up_reg_wb;break;
			default:ops[poo] = op_mov_reg;break;
			}
		break;
	case 0x1b:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_up_reg_wb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_up_reg_wb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_up_reg_wb;break;
			default:ops[poo] = op_movs_reg;break;
			}
		break;
	case 0x1c:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_up_imm_nowb;break;
			case 0xd:ops[poo] = op_strh_pre_up_imm_nowb;break;
			case 0xf:ops[poo] = op_strh_pre_up_imm_nowb;break;
			default:ops[poo] = op_bic_reg;break;
			}
		break;
	case 0x1d:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_up_imm_nowb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_up_imm_nowb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_up_imm_nowb;break;
			default:ops[poo] = op_bics_reg;break;
			}
		break;
	case 0x1e:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_up_imm_wb;break;
			case 0xd:ops[poo] = op_strh_pre_up_imm_wb;break;
			case 0xf:ops[poo] = op_strh_pre_up_imm_wb;break;
			default:ops[poo] = op_mvn_reg;break;
			}
		break;
	case 0x1f:
		switch(poo & 0xf)
			{
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_up_imm_wb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_up_imm_wb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_up_imm_wb;break;
			default:ops[poo] = op_mvns_reg;break;
			}
		break;
	case 0x20:ops[poo] = op_and_imm;break;
	case 0x21:ops[poo] = op_ands_imm;break;
	case 0x22:ops[poo] = op_error;break;
	case 0x23:ops[poo] = op_error;break;
	case 0x24:ops[poo] = op_sub_imm;break;
	case 0x25:ops[poo] = op_subs_imm;break;
	case 0x26:ops[poo] = op_rsb_imm;break;
	case 0x27:ops[poo] = op_rsbs_imm;break;
	case 0x28:ops[poo] = op_add_imm;break;
	case 0x29:ops[poo] = op_adds_imm;break;
	case 0x2a:ops[poo] = op_adc_imm;break;
	case 0x2b:ops[poo] = op_adcs_imm;break;
	case 0x2c:ops[poo] = op_error;break;
	case 0x2d:ops[poo] = op_error;break;
	case 0x2e:ops[poo] = op_error;break;
	case 0x2f:ops[poo] = op_error;break;
	case 0x30:ops[poo] = op_tst_imm;break;
	case 0x31:ops[poo] = op_tst_imm;break;
	case 0x32:ops[poo] = op_teq_imm;break;
	case 0x33:ops[poo] = op_teq_imm;break;
	case 0x34:ops[poo] = op_cmp_imm;break;
	case 0x35:ops[poo] = op_cmp_imm;break;
	case 0x36:ops[poo] = op_cmn_imm;break;
	case 0x37:ops[poo] = op_cmn_imm;break;
	case 0x38:ops[poo] = op_orr_imm;break;
	case 0x39:ops[poo] = op_orrs_imm;break;
	case 0x3a:ops[poo] = op_mov_imm;break;
	case 0x3b:ops[poo] = op_movs_imm;break;
	case 0x3c:ops[poo] = op_bic_imm;break;
	case 0x3d:ops[poo] = op_bics_imm;break;
	case 0x3e:ops[poo] = op_mvn_imm;break;
	case 0x3f:ops[poo] = op_mvns_imm;break;
	case 0x40:ops[poo] = op_str_imm_post_down;break;
	case 0x41:ops[poo] = op_ldr_imm_post_down;break;
	case 0x42:ops[poo] = op_str_imm_post_down;break;
	case 0x43:ops[poo] = op_ldr_imm_post_down;break;
	case 0x44:ops[poo] = op_strb_imm_post_down;break;
	case 0x45:ops[poo] = op_ldrb_imm_post_down;break;
	case 0x46:ops[poo] = op_strb_imm_post_down;break;
	case 0x47:ops[poo] = op_ldrb_imm_post_down;break;
	case 0x48:ops[poo] = op_str_imm_post_up;break;
	case 0x49:ops[poo] = op_ldr_imm_post_up;break;
	case 0x4a:ops[poo] = op_str_imm_post_up;break;
	case 0x4b:ops[poo] = op_ldr_imm_post_up;break;
	case 0x4c:ops[poo] = op_strb_imm_post_up;break;
	case 0x4d:ops[poo] = op_ldrb_imm_post_up;break;
	case 0x4e:ops[poo] = op_strb_imm_post_up;break;
	case 0x4f:ops[poo] = op_ldrb_imm_post_up;break;
	case 0x50:ops[poo] = op_str_imm_pre_down_nowb;break;
	case 0x51:ops[poo] = op_ldr_imm_pre_down_nowb;break;
	case 0x52:ops[poo] = op_str_imm_pre_down_wb;break;
	case 0x53:ops[poo] = op_ldr_imm_pre_down_wb;break;
	case 0x54:ops[poo] = op_strb_imm_pre_down_nowb;break;
	case 0x55:ops[poo] = op_ldrb_imm_pre_down_nowb;break;
	case 0x56:ops[poo] = op_strb_imm_pre_down_wb;break;
	case 0x57:ops[poo] = op_ldrb_imm_pre_down_wb;break;
	case 0x58:ops[poo] = op_str_imm_pre_up_nowb;break;
	case 0x59:ops[poo] = op_ldr_imm_pre_up_nowb;break;
	case 0x5a:ops[poo] = op_str_imm_pre_up_wb;break;
	case 0x5b:ops[poo] = op_ldr_imm_pre_up_wb;break;
	case 0x5c:ops[poo] = op_strb_imm_pre_up_nowb;break;
	case 0x5d:ops[poo] = op_ldrb_imm_pre_up_nowb;break;
	case 0x5e:ops[poo] = op_strb_imm_pre_up_wb;break;
	case 0x5f:ops[poo] = op_ldrb_imm_pre_up_wb;break;
	case 0x60:ops[poo] = op_str_reg_post_down;break;
	case 0x61:ops[poo] = op_ldr_reg_post_down;break;
	case 0x62:ops[poo] = op_str_reg_post_down;break;
	case 0x63:ops[poo] = op_ldr_reg_post_down;break;
	case 0x64:ops[poo] = op_strb_reg_post_down;break;
	case 0x65:ops[poo] = op_ldrb_reg_post_down;break;
	case 0x66:ops[poo] = op_strb_reg_post_down;break;
	case 0x67:ops[poo] = op_ldrb_reg_post_down;break;
	case 0x68:ops[poo] = op_str_reg_post_up;break;
	case 0x69:ops[poo] = op_ldr_reg_post_up;break;
	case 0x6a:ops[poo] = op_str_reg_post_up;break;
	case 0x6b:ops[poo] = op_ldr_reg_post_up;break;
	case 0x6c:ops[poo] = op_strb_reg_post_up;break;
	case 0x6d:ops[poo] = op_ldrb_reg_post_up;break;
	case 0x6e:ops[poo] = op_strb_reg_post_up;break;
	case 0x6f:ops[poo] = op_ldrb_reg_post_up;break;
	case 0x70:ops[poo] = op_str_reg_pre_down_nowb;break;
	case 0x71:ops[poo] = op_ldr_reg_pre_down_nowb;break;
	case 0x72:ops[poo] = op_str_reg_pre_down_wb;break;
	case 0x73:ops[poo] = op_ldr_reg_pre_down_wb;break;
	case 0x74:ops[poo] = op_strb_reg_pre_down_nowb;break;
	case 0x75:ops[poo] = op_ldrb_reg_pre_down_nowb;break;
	case 0x76:ops[poo] = op_strb_reg_pre_down_wb;break;
	case 0x77:ops[poo] = op_ldrb_reg_pre_down_wb;break;
	case 0x78:ops[poo] = op_str_reg_pre_up_nowb;break;
	case 0x79:ops[poo] = op_ldr_reg_pre_up_nowb;break;
	case 0x7a:ops[poo] = op_str_reg_pre_up_wb;break;
	case 0x7b:ops[poo] = op_ldr_reg_pre_up_wb;break;
	case 0x7c:ops[poo] = op_strb_reg_pre_up_nowb;break;
	case 0x7d:ops[poo] = op_ldrb_reg_pre_up_nowb;break;
	case 0x7e:ops[poo] = op_strb_reg_pre_up_wb;break;
	case 0x7f:ops[poo] = op_ldrb_reg_pre_up_wb;break;
	case 0x80:ops[poo] = op_error;break;
	case 0x81:ops[poo] = op_error;break;
	case 0x82:ops[poo] = op_stm_post_down_noload_wb;break;
	case 0x83:ops[poo] = op_ldm_post_down_noload_wb;break;
	case 0x84:ops[poo] = op_error;break;
	case 0x85:ops[poo] = op_error;break;
	case 0x86:ops[poo] = op_error;break;
	case 0x87:ops[poo] = op_error;break;
	case 0x88:ops[poo] = op_stm_post_up_noload_nowb;break;
	case 0x89:ops[poo] = op_ldm_post_up_noload_nowb;break;
	case 0x8a:ops[poo] = op_stm_post_up_noload_wb;break;
	case 0x8b:ops[poo] = op_ldm_post_up_noload_wb;break;
	case 0x8c:ops[poo] = op_error;break;
	case 0x8d:ops[poo] = op_error;break;
	case 0x8e:ops[poo] = op_error;break;
	case 0x8f:ops[poo] = op_error;break;
	case 0x90:ops[poo] = op_error;break;
	case 0x91:ops[poo] = op_error;break;
	case 0x92:ops[poo] = op_stm_pre_down_noload_wb;break;
	case 0x93:ops[poo] = op_ldm_pre_down_noload_wb;break;
	case 0x94:ops[poo] = op_error;break;
	case 0x95:ops[poo] = op_error;break;
	case 0x96:ops[poo] = op_error;break;
	case 0x97:ops[poo] = op_error;break;
	case 0x98:ops[poo] = op_error;break;
	case 0x99:ops[poo] = op_error;break;
	case 0x9a:ops[poo] = op_stm_pre_up_noload_wb;break;
	case 0x9b:ops[poo] = op_ldm_pre_up_noload_wb;break;
	case 0x9c:ops[poo] = op_error;break;
	case 0x9d:ops[poo] = op_error;break;
	case 0x9e:ops[poo] = op_error;break;
	case 0x9f:ops[poo] = op_error;break;
	case 0xa0:ops[poo] = op_b_pos;break;
	case 0xa1:ops[poo] = op_b_pos;break;
	case 0xa2:ops[poo] = op_b_pos;break;
	case 0xa3:ops[poo] = op_b_pos;break;
	case 0xa4:ops[poo] = op_b_pos;break;
	case 0xa5:ops[poo] = op_b_pos;break;
	case 0xa6:ops[poo] = op_b_pos;break;
	case 0xa7:ops[poo] = op_b_pos;break;
	case 0xa8:ops[poo] = op_b_neg;break;
	case 0xa9:ops[poo] = op_b_neg;break;
	case 0xaa:ops[poo] = op_b_neg;break;
	case 0xab:ops[poo] = op_b_neg;break;
	case 0xac:ops[poo] = op_b_neg;break;
	case 0xad:ops[poo] = op_b_neg;break;
	case 0xae:ops[poo] = op_b_neg;break;
	case 0xaf:ops[poo] = op_b_neg;break;
	case 0xb0:ops[poo] = op_bl_pos;break;
	case 0xb1:ops[poo] = op_bl_pos;break;
	case 0xb2:ops[poo] = op_bl_pos;break;
	case 0xb3:ops[poo] = op_bl_pos;break;
	case 0xb4:ops[poo] = op_bl_pos;break;
	case 0xb5:ops[poo] = op_bl_pos;break;
	case 0xb6:ops[poo] = op_bl_pos;break;
	case 0xb7:ops[poo] = op_bl_pos;break;
	case 0xb8:ops[poo] = op_bl_neg;break;
	case 0xb9:ops[poo] = op_bl_neg;break;
	case 0xba:ops[poo] = op_bl_neg;break;
	case 0xbb:ops[poo] = op_bl_neg;break;
	case 0xbc:ops[poo] = op_bl_neg;break;
	case 0xbd:ops[poo] = op_bl_neg;break;
	case 0xbe:ops[poo] = op_bl_neg;break;
	case 0xbf:ops[poo] = op_bl_neg;break;
	case 0xc0:ops[poo] = op_error;break;
	case 0xc1:ops[poo] = op_error;break;
	case 0xc2:ops[poo] = op_error;break;
	case 0xc3:ops[poo] = op_error;break;
	case 0xc4:ops[poo] = op_error;break;
	case 0xc5:ops[poo] = op_error;break;
	case 0xc6:ops[poo] = op_error;break;
	case 0xc7:ops[poo] = op_error;break;
	case 0xc8:ops[poo] = op_error;break;
	case 0xc9:ops[poo] = op_error;break;
	case 0xca:ops[poo] = op_error;break;
	case 0xcb:ops[poo] = op_error;break;
	case 0xcc:ops[poo] = op_error;break;
	case 0xcd:ops[poo] = op_error;break;
	case 0xce:ops[poo] = op_error;break;
	case 0xcf:ops[poo] = op_error;break;
	case 0xd0:ops[poo] = op_error;break;
	case 0xd1:ops[poo] = op_error;break;
	case 0xd2:ops[poo] = op_error;break;
	case 0xd3:ops[poo] = op_error;break;
	case 0xd4:ops[poo] = op_error;break;
	case 0xd5:ops[poo] = op_error;break;
	case 0xd6:ops[poo] = op_error;break;
	case 0xd7:ops[poo] = op_error;break;
	case 0xd8:ops[poo] = op_error;break;
	case 0xd9:ops[poo] = op_error;break;
	case 0xda:ops[poo] = op_error;break;
	case 0xdb:ops[poo] = op_error;break;
	case 0xdc:ops[poo] = op_error;break;
	case 0xdd:ops[poo] = op_error;break;
	case 0xde:ops[poo] = op_error;break;
	case 0xdf:ops[poo] = op_error;break;
	case 0xe0:ops[poo] = op_error;break;
	case 0xe1:ops[poo] = op_error;break;
	case 0xe2:ops[poo] = op_error;break;
	case 0xe3:ops[poo] = op_error;break;
	case 0xe4:ops[poo] = op_error;break;
	case 0xe5:ops[poo] = op_error;break;
	case 0xe6:ops[poo] = op_error;break;
	case 0xe7:ops[poo] = op_error;break;
	case 0xe8:ops[poo] = op_error;break;
	case 0xe9:ops[poo] = op_error;break;
	case 0xea:ops[poo] = op_error;break;
	case 0xeb:ops[poo] = op_error;break;
	case 0xec:ops[poo] = op_error;break;
	case 0xed:ops[poo] = op_error;break;
	case 0xee:ops[poo] = op_error;break;
	case 0xef:ops[poo] = op_error;break;
	case 0xf0:ops[poo] = op_swi;break;
	case 0xf1:ops[poo] = op_swi;break;
	case 0xf2:ops[poo] = op_swi;break;
	case 0xf3:ops[poo] = op_swi;break;
	case 0xf4:ops[poo] = op_swi;break;
	case 0xf5:ops[poo] = op_swi;break;
	case 0xf6:ops[poo] = op_swi;break;
	case 0xf7:ops[poo] = op_swi;break;
	case 0xf8:ops[poo] = op_swi;break;
	case 0xf9:ops[poo] = op_swi;break;
	case 0xfa:ops[poo] = op_swi;break;
	case 0xfb:ops[poo] = op_swi;break;
	case 0xfc:ops[poo] = op_swi;break;
	case 0xfd:ops[poo] = op_swi;break;
	case 0xfe:ops[poo] = op_swi;break;
	case 0xff:ops[poo] = op_swi;break;
	}
}
/*********************************************************************************************/
static INLINE void execute()
{
if(state == THUMB_MODE)
	{
	u32 dofunc;

	opcode = translate_thumb_opcode((u16)pipe[0],&dofunc);
	if(dofunc == 0)
		ops[((opcode >> 16) & 0xff0) | ((opcode >> 4) & 0xf)]();
	else
		thumb_opcode();
	}
else
	{
	u16 op;

	opcode = pipe[0];
	op = (u16)(((opcode >> 16) & 0xff0) | ((opcode >> 4) & 0xf));
	switch(OPCODE >> 28)
		{
		case 0x0:if(zeroflag){ops[op]();return;}break;
		case 0x1:if(zeroflag == 0){ops[op]();return;}break;
		case 0x2:if(carryflag){ops[op]();return;}break;
		case 0x3:if(carryflag == 0){ops[op]();return;}break;
		case 0x4:if(negativeflag){ops[op]();return;}break;
		case 0x5:if(negativeflag == 0){ops[op]();return;}break;
		case 0x6:if(overflowflag){ops[op]();return;}break;
		case 0x7:if(overflowflag == 0){ops[op]();return;}break;
		case 0x8:if(carryflag && zeroflag == 0){ops[op]();return;}break;
		case 0x9:if(carryflag == 0 && zeroflag){ops[op]();return;}break;
		case 0xa:if(negativeflag == overflowflag){ops[op]();return;}break;
		case 0xb:if(negativeflag != overflowflag){ops[op]();return;}break;
		case 0xc:if(zeroflag == 0 && (negativeflag == overflowflag)){ops[op]();return;}break;
		case 0xd:if(zeroflag || (negativeflag != overflowflag)){ops[op]();return;}break;
		case 0xe:ops[op]();return;
		default:execerror |= E_BADCOND;return;
		}
	cyclesexec += 1; //does skipping opcode eat a cycle?
	incpipe();
	}
}
/*********************************************************************************************/
static u8 INLINE getmodebank(u8 m)
{
switch(m)
	{
	case SYSTEM:
	case USER:return(USERBANK);
	case FIQ:return(FIQBANK);
	case SUPERVISOR:return(SUPERVISORBANK);
	case ABORT:return(ABORTBANK);
	case IRQ:return(IRQBANK);
	case UNDEFINED:return(UNDEFINEDBANK);
	default:emumessage("bad mode passed to getmodebank(): %02x\n",m);return(UNDEFINEDBANK);
	}
}
/*********************************************************************************************/
void arm7tdmi_init()
{
u32 i;

for(i=0;i<0x10000;i++)
	thumb_to_arm[i] = translate_thumb((u16)i);
for(i=0;i<0x1000;i++)
	fill_arm_func_table_entry((u16)i);
}
/*********************************************************************************************/
void arm7tdmi_modechange(u8 newmode)
{
if(mode != newmode)
	{
	u8 bank,newbank,i;

	bank = getmodebank(mode);
	newbank = getmodebank(newmode);
	switch(mode) //save old regs
		{
		case SYSTEM: //the manual says doesnt say (the way i interpret it) that
		case USER:   //these 2 get saved, but it i have to to get bios to run
		case SUPERVISOR:
		case ABORT:
		case IRQ:
		case UNDEFINED:
			if(newmode == FIQ) //all share r8-12 except fiq, so save them to common bank
				{
				for(i=8;i<13;i++)
					regsaves[USERBANK][i] = regs[i];
				}
			regsaves[bank][13] = regs[13];
			regsaves[bank][14] = regs[14];
			break;
		case FIQ:
			for(i=8;i<15;i++)
				regsaves[FIQBANK][i] = regs[i];
			break;
		}
	switch(newmode)
		{
		case SYSTEM:
		case USER:
		case SUPERVISOR:
		case ABORT:
		case IRQ:
		case UNDEFINED:
			if(mode == FIQ) //all share r8-12 except fiq, so restore them from common bank
				{
				for(i=8;i<13;i++)
					regs[i] = regsaves[USERBANK][i];
				}
			regs[13] = regsaves[newbank][13];
			regs[14] = regsaves[newbank][14];
			break;
		case FIQ:
			for(i=8;i<15;i++)
				regs[i] = regsaves[FIQBANK][i];
			break;
		}
	mode = newmode;
	}
}
/*********************************************************************************************/
u8 arm7tdmi_getmode()
{
return(state);
}
/*********************************************************************************************/
void arm7tdmi_getcontext(arm7tdmi *newcontext)
{
int i;

for(i=0;i<18;i++)
	{
	newcontext->regs[i] = regs[i];
	newcontext->regsaves[0][i] = regsaves[0][i];
	newcontext->regsaves[1][i] = regsaves[1][i];
	newcontext->regsaves[2][i] = regsaves[2][i];
	newcontext->regsaves[3][i] = regsaves[3][i];
	newcontext->regsaves[4][i] = regsaves[4][i];
	newcontext->regsaves[5][i] = regsaves[5][i];
	}
for(i=0;i<3;i++)
	newcontext->pipe[i] = pipe[i];
newcontext->state = state;
newcontext->read8 = read8;
newcontext->read16 = read16;
newcontext->read32 = read32;
newcontext->write8 = write8;
newcontext->write16 = write16;
newcontext->write32 = write32;
newcontext->regs[16] = notlazyflags(newcontext->regs[16]);
}
/*********************************************************************************************/
void arm7tdmi_setcontext(arm7tdmi *newcontext)
{
int i;

for(i=0;i<18;i++)
	{
	regs[i] = newcontext->regs[i];
	regsaves[0][i] = newcontext->regsaves[0][i];
	regsaves[1][i] = newcontext->regsaves[1][i];
	regsaves[2][i] = newcontext->regsaves[2][i];
	regsaves[3][i] = newcontext->regsaves[3][i];
	regsaves[4][i] = newcontext->regsaves[4][i];
	regsaves[5][i] = newcontext->regsaves[5][i];
	}
for(i=0;i<3;i++)
	pipe[i] = newcontext->pipe[i];
state = newcontext->state;
read8 = newcontext->read8;
read16 = newcontext->read16;
read32 = newcontext->read32;
write8 = newcontext->write8;
write16 = newcontext->write16;
write32 = newcontext->write32;
lazyflags(newcontext->regs[16]);
}
/*********************************************************************************************/
void arm7tdmi_softreset()
{
CPSR &= ~0x0000001f; //clear mode bits
CPSR |= 0x00000013; //set supervisor mode
CPSR |= IRQ_DISABLE | FIQ_DISABLE; //disable these
PC = 0;
cycles = 0;
arm7tdmi_modechange((u8)(CPSR & 0x1f));
armmode();
fillpipe();
}
/*********************************************************************************************/
void arm7tdmi_hardreset()
{
int i;

for(i=0;i<18;i++)
	{
	regs[i] = 0;
	regsaves[0][i] = 0;
	regsaves[1][i] = 0;
	regsaves[2][i] = 0;
	regsaves[3][i] = 0;
	regsaves[4][i] = 0;
	regsaves[5][i] = 0;
	}
arm7tdmi_softreset();
}
/*********************************************************************************************/
void arm7tdmi_fillpipe()
{
fillpipe();
}
/*********************************************************************************************/
u32 arm7tdmi_getcycles()
{
return(cycles);
}
/*********************************************************************************************/
u32 arm7tdmi_execute(u32 cyclestodo)
{
u32 ret;

while(cyclesexec < cyclestodo)
	{
	execute();
	if(execerror) //error
		break;
	}
cycles += cyclesexec;
ret = cyclesexec | execerror;
cyclesexec = 0;
execerror = 0;
return(ret);
}
/*********************************************************************************************/
u32 arm7tdmi_executeop()
{
u32 ret;

execute();
cycles += cyclesexec;
ret = cyclesexec | execerror;
cyclesexec = 0;
execerror = 0;
return(ret);
}
/*********************************************************************************************/
void arm7tdmi_addcycles(u32 cycles)
{
cyclesexec += cycles;
}
/*********************************************************************************************/
